<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::get('/getstatefromcountry', 'AjaxConrtoller@getstate');
Route::post('/postajax', 'AjaxConrtoller@NewReservation');

Route::get('/stationlist/{id}', 'AjaxConrtoller@stationlist');

Route::post('/finalreservation', 'AjaxConrtoller@finalreservation');
Route::post('/poststore', 'api\ApiController@poststore');


Route::resource('apicall', 'api\ApiController');
Route::get('/postdata', 'api\ApicallController@postdata');
Route::get('/getbereartoken', 'api\ApicallController@getbereartoken');
Route::get('/testmail', 'api\ApicallController@testmail');









////////////////general api for app ///////

Route::post('/getsearchdata', 'appapi\AppapiController@getsearchdata');
Route::post('/createuser', 'appapi\AppapiController@createuser');
Route::post('/updateuser', 'appapi\AppapiController@updateuser');
Route::get('/getservice', 'appapi\AppapiController@getservice');
Route::post('/bookings', 'appapi\AppapiController@bookings');
Route::post('/newreserve', 'appapi\AppapiController@newreserve');
Route::post('/postcontact', 'appapi\AppapiController@postcontact');
Route::post('/forgotpass', 'appapi\AppapiController@forgotpass');
Route::post('/forgotpassword', 'appapi\AppapiController@forgotpassword');
Route::post('/idchange', 'appapi\AppapiController@idchange');
Route::get('/pages', 'appapi\AppapiController@pages');
Route::get('/pay/{id}/{amt}/{token}', 'appapi\AppapiController@pay');


////////////////important api for app ///////

Route::get('/pickupdrop', 'carhireapi\ApiController@pickupdrop');
Route::post('/userstore', 'carhireapi\ApiController@userstore');
Route::post('/userlogin', 'carhireapi\ApiController@userlogin');
Route::post('/updpass', 'carhireapi\ApiController@updpass');
Route::post('/upduser', 'carhireapi\ApiController@upduser');
Route::post('/getsearchdata', 'carhireapi\ApiController@search');
Route::get('/getupsells', 'carhireapi\ApiController@upsells');
Route::get('/setting', 'carhireapi\ApiController@settings_e');
Route::post('/checkcouponcode', 'carhireapi\ApiController@checkcouponcode');
Route::get('/settings', 'carhireapi\ApiController@settings');
Route::post('/newreserve', 'carhireapi\ApiController@newreserve');
Route::post('/postreview/{id}', 'carhireapi\ApiController@postreview');
Route::get('/getbooking/{id}', 'carhireapi\ApiController@getbooking');
Route::get('/cancelbooking/{id}', 'carhireapi\ApiController@cancelbooking');
Route::get('/getbookings_active/{id}', 'carhireapi\ApiController@getbookings_active');
Route::post('/validatesearch', 'carhireapi\ApiController@validatesearch');
Route::get('/getbookings_cancelled/{id}', 'carhireapi\ApiController@getbookings_cancelled');
Route::get('/deluser/{id}', 'carhireapi\ApiController@deluser');
Route::post('create-checkout-session', 'carhireapi\ApiController@postcheckout');
Route::get('/checkout', 'carhireapi\ApiController@checkout');
Route::get('/vehicletype', 'carhireapi\ApiController@getvehicletype');
Route::get('createstripe', 'carhireapi\ApiController@createstripe');
