<x-app-layout>
    @include('admin.include.sidebar')
    <nav class="navbar navbar-expand-lg navbar-light bg-light">
        <div class="container-fluid">

            <button type="button" id="sidebarCollapse" class="btn btn-danger">
                <i class="fas fa-align-left"></i>
            </button>
            <button class="btn btn-dark d-inline-block d-lg-none ml-auto" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <i class="fas fa-align-justify"></i>
            </button>
            @if(session()->has('success'))
            <div class="alert alert-success mb-0 alert-dismissible fade show" role="alert">
                {{ session()->get('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            @endif
            @if(session()->has('error'))
            <div class="alert alert-danger mb-0 alert-dismissible fade show" role="alert">
                {{ session()->get('error') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            @endif
            <a class="btn btn-danger" href='{{route("partner.create")}}'>Create New Partner</a>

        </div>
    </nav>
    <!-- Page Content  -->
    <div class="wrapper">
        <!-- Sidebar  -->


        <!-- Page Content  -->
        <div id="content" style="padding: 20px 0;">
            <!-- <button class="btn btn-danger mb-4"> <a href='{{route("tax.create")}}'>Create New Tax</a> </button> -->
            <div class="navbar-expand-lg navbar-light bg-light">
                <table id="example" class="table table-striped table-bordered dark" style="width:100%">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>City</th>
                            <th>Phone(s)</th>
                            <th>Email</th>
                            <th>Join Date</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($partners as $partner)
                        <tr>
                            <td>{{$partner->id}}</td>
                            <td><a href="{{route("partner.show", $partner->id)}}" style="color:blue;">{{$partner->partner_fname}} {{$partner->partner_lname}}</a></td>
                            <td>{{$partner->partner_city}}</td>
                            <td>{{$partner->partner_phone_1}}</td>
                            <td>{{$partner->partner_email}}</td>
                            <td>{{$partner->partner_join_date}}</td>
                            <td>
                                @if($partner->partner_status==1)
                                    <span>Active</span>
                                @else
                                    <span>Inactive</span>
                                @endif
                            </td>
                            <td class="action">
                                  <a href="{{route("partner.edit", $partner->id)}}"><i class="fa fa-edit"></i></a>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>


        </div>
    </div>

    <script type="text/javascript">
        function condelete() {
            var message = confirm("Do you really want to delete");
            if (message == true) {
                return true;
            } else {
                return false;
            }
        }
        bootbox.confirm("Are you sure?", function(result) {
            Example.show("Confirm result: " + result);
        });
    </script>
</x-app-layout>