<?php

namespace App\Http\Controllers\admin\setting;

use DateTimeZone;
use App\Models\Setting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class SettingController extends Controller
{
    public function index()
    {
        $coupon = Setting::all();
        return view('admin.setting.index')->with(['coupon' => $coupon]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.setting.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->all();
        if ($request->hasFile('image')) {
            $data['image'] = $request->image->storeAs('/public/images', time().".".$request->image->extension());
        }
        Setting::create($data);
        return redirect('/admin/setting')->with('success','Uploaded Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $coupon = Setting::find($id);
        $cur = DB::table('currency')->orderBy('country','asc')->get();
        $country = DateTimeZone::listIdentifiers(DateTimeZone::ALL);
        return view('admin.setting.edit')->with(['coupon' => $coupon,'currency' => $cur,'country' => $country]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->all();
        if ($request->hasFile('image')) {
            $data['image'] = $request->image->storeAs('/public/images', time().".".$request->image->extension());
        }
        Setting::find($id)->update($data);
        return redirect('/admin/setting')->with('success','Data Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Setting::find($id)->delete();
        return redirect('/admin/setting')->with('success','Data Deleted Successfully');
    }
}
