<?php

namespace App\Http\Controllers\admin\availability;

use App\Models\Availability;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class AvailabilityController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($id)
    {
        $avail = Availability::where(['car_id' => $id])->get();
        return view('admin.availability.index')->with(['id' => $id,'availability' => $avail]);
    }

    public function new()
    {
        $data = request()->all();
        unset($data['_token']);
        Availability::find($data['id'])->update($data);
        return response(request()->all());
    }

    public function delone()
    {
        $data = request()->all();
        unset($data['_token']);
        Availability::find($data['id'])->delete();
        return response(request()->all());
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request,$id)
    {
        $data = request()->all();
        Availability::where(['car_id' => $id])->delete();
        for ($i=0; $i < count($data['startdate']); $i++) { 
            $val['car_id'] = $id;
            $val['start_date'] = $data['startdate'][$i];
            $val['start_time'] = $data['starttime'][$i];
            $val['end_date'] = $data['enddate'][$i];
            $val['end_time'] = $data['endtime'][$i];
            Availability::create($val);
        }
        
        return redirect()->route('cars.availability.index',$id)->with('success','Data Updated Successfully');
        
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
