<?php

namespace App\Http\Controllers;

use App\Models\Pages;
use App\Models\Contact;
use Ramsey\Uuid\Uuid;
use App\Mail\IdnoMail;
use App\Mail\TestMail;
use App\Mail\ContactMail;
use App\Mail\OrderMail;
use App\Mail\CancelOrder;
use Illuminate\Http\Request;
use App\Models\Advertisement;
use Illuminate\Support\Facades\Mail;
use App\Http\Controllers\api\ApiController;
use App\Http\Controllers\PayfortController;
use App\Http\Controllers\api\ApicallController;
use MoeenBasra\Payfort\PayfortFacade as Payfort;
use App\Http\Controllers\price\PriceingController;
use App\Models\Location;
use App\Models\Service;
use Illuminate\Support\Str;

class WebController extends Controller
{
    public function index()
    {
        $data['offer'] = Advertisement::where(['status' => 1])->get();
        $data['about'] = Pages::find(1);
        $data['vision'] = Pages::find(2);
        $data['misson'] = Pages::find(3);
        $data['ListStation'] = (new ApiController)->show('PCRLookup/ListStation');
        
        $data['ListStation'] = $data['ListStation']['Result']['stationList'];
        unset($data['ListStation'][0]);
        unset($data['ListStation'][3]);
        unset($data['ListStation'][4]);
        unset($data['ListStation'][5]);
        unset($data['ListStation'][8]);
        unset($data['ListStation'][16]);
        unset($data['ListStation'][11]);
        
        $data['ListStation'] = array_values($data['ListStation']);
        // $data['vehicleViewModelList'] = $data['vehicleViewModelList']['Result']['vehicleViewModelList'];
        // dd($data['ListStation']);
        return view('frontend.index')->with($data);
    }

    public function search()
    {
        $data['ListStation'] = (new ApiController)->show('PCRLookup/ListStation');
        
        $data['ListStation'] = $data['ListStation']['Result']['stationList'];
        unset($data['ListStation'][0]);
        unset($data['ListStation'][3]);
        unset($data['ListStation'][4]);
        unset($data['ListStation'][5]);
        unset($data['ListStation'][8]);
        unset($data['ListStation'][16]);
        unset($data['ListStation'][11]);
        // $data['ListVehicleMakeModel'] = (new ApiController)->show('PCRLookup/ListVehicleMakeModel');
        // $data['ListVehicleMakeModel'] = $data['ListVehicleMakeModel']['Result']['vehicleMakeModelList'];
        
        
        $pickuptime = $this->converttime(request('rezerve-pickup-time'));
        $droptime = $this->converttime(request('rezerve-drop-time'));
        $data['pickupdatetime'] = (new PriceingController)->datetimetotzformat(request('rezerve-pickup-date'),$pickuptime);
        $data['dropdatetime'] = (new PriceingController)->datetimetotzformat(request('rezerve-pickup-date'),$pickuptime);
        $data['pickuplocation'] = request('pickuplocation');
        
        $data['vehicleViewModelList'] = (new ApiController)->show('PCRVehicle/ListVehicle_Available_Date?stationCode='.$data['pickuplocation'].'&fromDate='.$data['pickupdatetime'].'&toDate='.$data['dropdatetime']);
        $data['vehicleList'] = $data['vehicleViewModelList']['Result']['vehicleViewModelList'];

        $data['ListVehicleMakeModel'] = $this->getmakemodel($data['vehicleList']);
        // dd($data['ListVehicleMakeModel']);

        $days = $this->getnumberofdays();
        if ($days == 0) {
            $days = 1;
        } 

        $data['days'] = $days;

        $data['namelocation'] = (new ApiController)->show('PCRLookup/ListStation');
        // dd($data['namelocation']['Result']['stationList']);
        $data['pickupnamelocation'] = $this->getstationname($data['namelocation']['Result']['stationList'],request('pickuplocation'));
        $data['returnnamelocation'] = $this->getstationname($data['namelocation']['Result']['stationList'],request('returnlocation'));
        if (request('luggage')) {
            // dd(request('luggage'));
            $data['vehicleList']  = $this->filterluggage(request('luggage'),$data['vehicleList']);
        }

        // if (request('door')) {
        //     $data['vehicleList']  = $this->filterdoor(request('door'),$data['vehicleList']);
        // }

        if (request('sort')) {
            usort($data['vehicleList'], function($a, $b) {
                return $a['daily_price'] <=> $b['daily_price'];
            });

            if (request('sort') == 'hightolow') {
                $data['vehicleList'] = array_reverse($data['vehicleList']);
            } 
        }

        $data['vehicleList'] = $this->pushimage($data['vehicleList']);
        // dd($data['vehicleList']);
        return view('frontend.search')->with($data);
    }

    public function getmakemodel($var)
    {

        $unique = array();

        foreach ($var as $value)
        {
            $unique[$value['car_make_code']] = $value;
        }

        return $data = array_values($unique);
        // dd($data);
    }

    public function pushimage($data)
    {
        for ($i=0; $i < count($data); $i++) { 

            switch ($data[$i]['car_model']) {
                case 'Mazda3':
                    $data[$i]['car_image'] = env('APP_URL').'carimage/800-600/Mazda3.png';
                  break;
                case "Mazda CX9":
                    $data[$i]['car_image'] = env('APP_URL').'carimage/1360-903/mazda_CX-9-2019-2020.jpg';
                  break;
                case "Kia Rio":
                    $data[$i]['car_image'] = env('APP_URL').'carimage/1360-903/kia-rio-2020.jpg';
                  break;
                case 'Mazda6 S':
                    $data[$i]['car_image'] = env('APP_URL').'carimage/1360-903/MAZDA-CX5-2018-2019-2020.jpg';
                  break;
                case "Mazda CX3":
                    $data[$i]['car_image'] = env('APP_URL').'carimage/1360-903/Mazda-CX-3-2020-2019-2018.jpg';
                  break;
                case "Mazda6":
                    $data[$i]['car_image'] = env('APP_URL').'carimage/800-600/mazda-6-2019-2020.jpg';
                  break;
                default:
                $data[$i]['car_image'] = env('APP_URL').'carimage/1360-903/Elantra-2019.jpg';
              }
        }
        return $data;
    }

    public function getstationname($array,$id)
    {
        foreach ($array as $value) {
            if ($value['s_code'] == $id) {
                return $value['s_name'];
            }
        }
    }

    public function filterdoor($door,$vehicleViewModelList)
    {
        $array = [];
        for ($i=0; $i < count($vehicleViewModelList); $i++) { 
            if (intval($vehicleViewModelList[$i]['doors']) == intval($door)) {
                array_push($array,$vehicleViewModelList[$i]);
            }
        }
        return $array;
    }

    public function filterluggage($luggagenumber,$vehicleViewModelList)
    {
        // dd($vehicleViewModelList);
        $array = [];
        for ($i=0; $i < count($vehicleViewModelList); $i++) { 
            if (intval($vehicleViewModelList[$i]['car_make_code']) == intval($luggagenumber)) {
                array_push($array,$vehicleViewModelList[$i]);
            }
        }
        return $array;
    }

    public function getnumberofdays()
    {
        $pickupdate = strtotime(request('pickupp').' '.request('rezerve-pickup-time')); // or your date as well
        $return_date = strtotime(request('returndate').' '.request('dropHour'));
        $datediff = $pickupdate - $return_date;

        return ceil(abs(intval(round($datediff / (60 * 60))))/24);
    }

    public function converttime($pickuptime)
    {
        return date_format(date_create($pickuptime),'H:i:s');
    }

    public function services()
    {
        $data['service'] = Service::where(['status' => 1])->get();
        return view('frontend.services')->with($data);
    }

    public function about()
    {
        $pages['about'] = Pages::find(1);
        $pages['vision'] = Pages::find(2);
        $pages['misson'] = Pages::find(3);
        return view('frontend.about')->with($pages);
    }

    public function reviews()
    {
        return view('frontend.reviews');
    }

    public function locations()
    {
        $data['location'] = Location::where(['status' => 1])->get();
        $data['western'] = Location::where(['status' => 1,'region' => 1])->get();
        $data['eastern'] = Location::where(['status' => 1,'region' => 0])->get();
        return view('frontend.locations')->with($data);
    }

    public function contact()
    {
        $data['contact'] = Contact::find(1);
        return view('frontend.contact')->with($data);
    }

    public function postcontact()
    {
        $val = request()->all();
        $data = Pages::find(12);

        if (session('language') == 'Arabic') {
            $data->description = str_replace(["%%CUSTOMER_NAME%%","%%CUSTOMER_PHONE%%","%%CUSTOMER_EMAIL%%","%%MESSAGE%%"],[$val['name'],$val['phone'],$val['email'],$val['message']],$data->description_a);
        } else {
            $data->description = str_replace(["%%CUSTOMER_NAME%%","%%CUSTOMER_PHONE%%","%%CUSTOMER_EMAIL%%","%%MESSAGE%%"],[$val['name'],$val['phone'],$val['email'],$val['message']],$data->description);
        }
        Mail::to(env('ADMIN_MAIL_ADDRESS'))->send(new ContactMail($data));
        Mail::to($val['email'])->send(new ContactMail($data));
        return redirect()->back()->with('succmessage', 'Contact Mail Send Successfully');
    }

    public function myaccount()
    {
        $data['users'] = session('user')->Customer;
        // dd(session('user'));
        return view('frontend.profile')->with($data);
    }

    public function bookinghistory()
    {
        $cus_code = session('user')->Customer->cus_code;
        $data['currentbooking'] = (new ApicallController)->getauthenticateddata('PCRReservation/ListReservation?customerCode='.$cus_code.'&statusCode=V');
        $data['cancelledbooking'] = (new ApicallController)->getauthenticateddata('PCRReservation/ListReservation?customerCode='.$cus_code.'&statusCode=C');
        $data['currentbooking'] = array_reverse($data['currentbooking']['Result']['reservationViewModelLists']);
        $data['currentbooking']['Result']['reservationViewModelLists'] = $this->getpaidbooking($data['currentbooking']);
        return view('frontend.my-booking',$data);
    }

    public function getpaidbooking($var)
    {
        $array = [];
        foreach ($var as $value) {
            if ($value['prepaid'] == "1") {
                array_push($array,$value);
            }
        }
        return $array;
    }

    public function mail()
    {
        $data = Pages::find(5);
        if (session('language') == 'Arabic') {
            $data->description = str_replace("%%USERNAME%%","test",$data['description_a']);
        } else {
            $data->description = str_replace("%%USERNAME%%","test",$data['description']);
        }
        // dd($data);
        Mail::to('sailapritam@gmail.com')->bcc('deltarohit@gmail.com')->send(new TestMail($data));
    }

    public function changepassword()
    {
        if (session('user')) {
            session()->flash('errormessage', 'User already in session');
            return redirect('/');
        }
        $id = $this->base64url_decode(request('key'));
        return view('frontend.change-password')->with(['id' => $id]);
    }

    public function postchangepassword()
    {
        $customerCode = request('customerCode');
        if (request('password') != request('cnfpassword')) {
            session()->flash('errormessage', 'Password And Confirm Password Doesnot Match');
            return redirect('/');
        }
        
        $password = request('password');
        $res = json_decode((new ApicallController)->postdata('PCRCustomer/CustomerChangePassword?customerCode='.$customerCode.'&password='.$password)->content());
        // dd($res);
        if ($res->Status == 201) {
            session()->flash('succmessage', 'Password Successfully Updated');
            return redirect('/');
        } else {
            session()->flash('errormessage', 'Something Went Wrong');
            return redirect('/');
        }
    }

    public function idchange()
    {
        $idno = request('idno');

        $res = json_decode((new ApicallController)->postdata('PCRCustomer/CustomerByIdNo?idno='.$idno)->content());
        // dd($res->Result);
        if ($res->Status == 201) {
            $data = Pages::find(8);
            if (session('language') == 'Arabic') {
                $data->description = str_replace(["%%CUSTOMER_EMAIL%%","%%CUSTOMER_NAME%%","%%CUSTOMER_PHONE%%","%%CUSTOMER_ID%%"],[$res->Result->e_mail,$res->Result->cus_name,$res->Result->per_mobile,$res->Result->id_no],$data['description_a']);
            } else {
                $data->description = str_replace(["%%CUSTOMER_EMAIL%%","%%CUSTOMER_NAME%%","%%CUSTOMER_PHONE%%","%%CUSTOMER_ID%%"],[$res->Result->e_mail,$res->Result->cus_name,$res->Result->per_mobile,$res->Result->id_no],$data['description']);
            }
            Mail::to($res->Result->e_mail)->send(new IdnoMail($data));
            session()->flash('succmessage', 'Customer Found And mail has been sent to '.$res->Result->e_mail);
            return redirect('/');
        } else {
            session()->flash('errormessage', 'Customer not found');
            return redirect('/');
        }
    }

    public function base64url_decode($data) {
        return base64_decode(str_pad(strtr($data, '-_', '+/'), strlen($data) % 4, '=', STR_PAD_RIGHT));
    }

    public function thankyou()
    {
        $pages['thanks'] = Pages::find(9);
        return view('frontend.thankyou')->with($pages);
    }

    public function cancel()
    {
        $pages['cancel'] = Pages::find(10);
        return view('frontend.cancel')->with($pages);
    }

    public function privacy()
    {
        $pages['privacy'] = Pages::find(4);
        return view('frontend.privacy')->with($pages);
    }
}
