<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::middleware('auth')->group(function () {
    Route::view('/dashboard', 'dashboard')->name('dashboard');
    Route::view('/checkout', 'checkout')->name('checkout');
    Route::view('/admin2209', 'auth.login');
    Route::resource('admin/cars', 'admin\cars\CarController');
    Route::get('admin/cars_del', 'admin\cars\CarController@delimage');


    Route::resource('admin/cars.availability', 'admin\availability\AvailabilityController');
    Route::resource('admin/service', 'admin\service\ServiceController');
    Route::resource('admin/pages', 'admin\pages\PagesController');
    Route::resource('admin/location', 'admin\location\LocationController');
    Route::resource('admin/coupon', 'admin\coupon\CouponController');
    Route::resource('admin/pickupdrop', 'admin\pickupdrop\PickupDropLocationController');
    Route::resource('admin/carsmodel', 'admin\carsmodel\CarsModelController');
    Route::resource('admin/carstype', 'admin\carstype\CarsTypeController');
    Route::resource('admin/setting', 'admin\setting\SettingController');
    Route::resource('admin/tax', 'admin\tax\TaxController');
    Route::resource('admin/usermanage', 'admin\user\UserController');
    Route::resource('admin/upsell', 'admin\upsell\UpsellController');
    Route::resource('admin/review', 'admin\review\ReviewController');
    Route::resource('admin/booking', 'admin\booking\BookingController');
    Route::resource('admin/banner', 'admin\banner\Bannercontroller');
    Route::resource('admin/partner', 'admin\partner\PartnerController');
    Route::post('newone', 'admin\availability\AvailabilityController@new');
    Route::post('delone', 'admin\availability\AvailabilityController@delone');
});

// Route::get('/dashboard', function () {
//     // return view('dashboard');

// })->middleware(['auth'])->name('dashboard');



require __DIR__ . '/auth.php';