<?php

namespace App\Http\Controllers\frontend\user;

use App\Models\Pages;
use App\Mail\RegisterMail;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;
use App\Http\Controllers\api\ApicallController;

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = request()->all();
        if (isset($data['_token'])) {
            unset($data['_token']);
        }

        // return response($data);
        
        // dd($data);
        // if (!$data['per_city']) {
        //     $data['per_city'] == '0';
        // }

        // if (!$data['birth_city']) {
        //     $data['birth_city'] == '0';
        // }
        $val = (new ApicallController)->authenticatepostdata('PCRCustomer/NewCustomer',$data)->content();
        // dd($val);
        $val = json_decode($val);

        if ($val->Status == 201) {
            // $data = [
            //     'username' => request('e_mail'),
            //     'password' => request('online_password')
            // ];

            $data = Pages::find(5);
            if (session('language') == 'Arabic') {
                $data->description = str_replace("%%USERNAME%%",request('e_mail'),$data['description_a']);
                Mail::to(env('ADMIN_MAIL_ADDRESS'))->send(new RegisterMail($data));
                Mail::to(request('e_mail'))->send(new RegisterMail($data));
                session()->flash('succmessage', 'تم التسجيل بنجاح ، قم بتسجيل الدخول الآن');
            } else {
                $data->description = str_replace("%%USERNAME%%",request('e_mail'),$data['description']);
                Mail::to(env('ADMIN_MAIL_ADDRESS'))->send(new RegisterMail($data));
                Mail::to(request('e_mail'))->send(new RegisterMail($data));
                session()->flash('succmessage', 'Registered Successfully,Login Now');
            }
            return redirect('/');
        } else {
            if (session('language') == 'Arabic') {
                session()->flash('errormessage', 'رقم الهوية موجود بالفعل');
            return redirect('/');
            } else {
                session()->flash('errormessage', 'Id Number Already exists');
            return redirect('/');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = request()->all();
        unset($data['_method']);
        unset($data['_token']);
        $token = session('user')->Token;
        if (!isset($data['birth_city'])) {
            $data['birth_city'] = 0;
        }

        if (!isset($data['per_city'])) {
            $data['per_city'] = 0;
        }
        $res = (new ApicallController)->authenticatepostdata('PCRCustomer/EditCustomer?customerCode='.$id,$data,$token);

        $res = json_decode($res->content());

        $userdata = (new ApicallController)->getauthenticateddata('PCRCustomer/ViewCustomer?customerCode='.$res->Result);
        session('user')->Customer = json_decode(json_encode($userdata['Result']['customerViewModel']));
        // dd(session('user')->Customer);
        session(['user' => session('user')]);
        return redirect('myaccount')->withErrors(['Data Updated Successfully']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
