<?php

namespace App\Http\Controllers\carhireapi;

use DateTime;
use Slim\App;
use Stripe\Stripe;
use App\Models\Car;
use App\Models\Tax;
use App\Models\User;
use App\Models\Banner;
use App\Models\Coupon;
use App\Models\Review;
use App\Models\Upsell;
use Slim\Http\Request;
use App\Models\Booking;
// use Illuminate\Http\Request;
use App\Models\Setting;
use Slim\Http\Response;
use App\Models\CarModel;
// use Illuminate\Support\Facades\App;
use Stripe\PaymentIntent;
use Stripe\Checkout\Session;
use Illuminate\Support\Carbon;

use App\Models\PickupDropLocation;
use App\Http\Controllers\Controller;
use App\Models\CarType;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Redirect;

class ApiController extends Controller
{
    public function pickupdrop()
    {
        $data['location'] = PickupDropLocation::where(['status' => 1])->get();
        $data['banner'] = Banner::where(['status' => 1])->get();
        for ($i = 0; $i < count($data['banner']); $i++) {
            $data['banner'][$i]->image = url(Storage::url($data['banner'][$i]->image));
        }
        return response($data);
    }

    public function userstore()
    {
        $data = request()->all();
        $data['role'] = 'User';
        $data['password'] = Hash::make($data['password']);
        User::create($data);
        return response($data);
    }

    public function userlogin()
    {
        $data = request()->all();
        $user = User::where(['email' => $data['email']])->first();
        if (Hash::check($data['password'], $user->password)) {
            return response($user);
        } else {
            return response(['message' => 'Unauthorized'], 401);
        }
    }

    public function updpass()
    {
        $data = request()->all();
        $user = User::where(['id' => $data['id']])->first();
        if (Hash::check($data['currentpass'], $user->password)) {
            $data['newpass'] = Hash::make($data['newpass']);
            User::where(['id' => $data['id']])->update(['password' => $data['newpass']]);
            return response(['message' => 'Successfully Updated']);
        } else {
            return response(['message' => 'Unauthorized'], 401);
        }
    }

    public function upduser()
    {
        $data = request()->all();
        User::where(['id' => $data['id']])->update($data);
        return response(['message' => 'Successfully Updated']);
    }

    public function search()
    {
        $data = request()->all();

        if (isset($data['luggage'])) {
            $car = Car::where(['carmodel_id' => $data['luggage']])->whereRaw('FIND_IN_SET(?,station_ids)', [$data['pickuplocation']])
                ->get();
        } else if (isset($data['vehicletype'])) {
            $car = Car::where(['cartype_id' => $data['vehicletype']])->whereRaw('FIND_IN_SET(?,station_ids)', [$data['pickuplocation']])
                ->get();
        } else if (isset($data['seat'])) {
            $car = Car::where(['person' => $data['seat']])->whereRaw('FIND_IN_SET(?,station_ids)', [$data['pickuplocation']])
                ->get();
        } else if (isset($data['luggages'])) {
            $car = Car::where(['luggage' => $data['luggages']])->whereRaw('FIND_IN_SET(?,station_ids)', [$data['pickuplocation']])
                ->get();
        } else if (isset($data['geartype'])) {
            $car = Car::where(['gear' => $data['geartype']])->whereRaw('FIND_IN_SET(?,station_ids)', [$data['pickuplocation']])
                ->get();
        } else if (isset($data['fueltype'])) {
            $car = Car::where(['distance' => $data['fueltype']])->whereRaw('FIND_IN_SET(?,station_ids)', [$data['pickuplocation']])
                ->get();
        } else if (isset($data['pricerange'])) {
            $fueltype = explode("-", $data['pricerange']);
            $car = Car::whereBetween('price', [$fueltype[0], $fueltype[1]])->whereRaw('FIND_IN_SET(?,station_ids)', [$data['pickuplocation']])
                ->get();
        } else {
            $car = Car::whereRaw('FIND_IN_SET(?,station_ids)', [$data['pickuplocation']])
                ->get();
        }

        $days = $this->getnumberofdays();

        for ($i = 0; $i < count($car); $i++) {
            $image = unserialize($car[$i]['image']);
            $array = [];
            foreach ($image as $value) {
                array_push($array, env('APP_URL') . Storage::url($value));
            }

            if ($days === 7) {
                $car[$i]['newprice'] = $car[$i]['fromyears'];
            } else if ($days < 7) {
                $car[$i]['newprice'] = $car[$i]['price'] * $days;
            } else if ($days > 7) {
                $dividen = ($days % 7);
                $weekdays = intval($days / 7);
                $car[$i]['newprice'] = ($car[$i]['fromyears'] * $weekdays) + $car[$i]['price'] * $dividen;
            }

            $car[$i]['review'] = Review::where(['forcar' => $car[$i]['id']])->avg('rating');
            $car[$i]['image'] = $array;
            $car[$i]['car_model'] = CarModel::find($car[$i]['carmodel_id'])['name'];
        }



        // return response($car);
        $location = PickupDropLocation::where(['status' => 1])->get();
        $model = CarModel::where(['status' => 1])->get();

        // if ($days == 0) {
        //     $days = 1;
        // }

        if (request('sort')) {
            $car = $car->toArray();
            usort($car, function ($a, $b) {
                return $a['price'] <=> $b['price'];
            });

            if (request('sort') == 'hightolow') {
                $car = array_reverse($car);
            }
        }



        if (request('pickuplocation')) {
            $pickup = PickupDropLocation::where(['id' => request('pickuplocation')])->first()->name;
            $drop = PickupDropLocation::where(['id' => request('returnlocation')])->first()->name;
        }
        return response(['pickupnamelocation' => $pickup, 'returnnamelocation' => $drop, 'days' => $days, 'vehicleList' => $car, 'location' => $location, 'ListVehicleMakeModel' => $model]);
    }

    public function getnumberofdays()
    {
        date_default_timezone_set($this->setting->timezone);

        $pickuptime = date('h:i:s', strtotime(request('pickuptime')));
        $dropHour = date('h:i:s', strtotime(request('dropHour')));

        $pickdateTime = request('pickupp') . ' ' . $pickuptime;
        $returndateTime = request('returndate') . ' ' . $dropHour;

        $pickupDate = Carbon::createFromFormat('d/m/Y h:i:s', $pickdateTime);
        $returnDate = Carbon::createFromFormat('d/m/Y h:i:s', $returndateTime);

        // echo $pickupDate;
        // echo $returnDate;
        // die;

        $diff = $pickupDate->diffInDays($returnDate);

        return $diff;
        // return response(['pickupDate' => $pickupDate, 'returnDate' => $returnDate, 'diff' => $diff]);
    }

    public function upsells()
    {
        $data['upsells'] = Upsell::where(['status' => 1])->get();
        $data['tax'] = Tax::all();
        return response($data);
    }

    public function checkcouponcode()
    {
        $coupon = Coupon::where(['offer_code' => request('couponcode')])->first();
        if ($coupon) {
            if ($coupon->minimum_ord_amt < request('ordamt')) {
                $inbetween = $this->dateIsInBetween($coupon->start_date, $coupon->end_date, date('Y-m-d'));
                if ($inbetween) {
                    if ($coupon->offer_type === 'Flat') {
                        $newamt = request('ordamt') - $coupon->description;
                    } else {
                        $newamt = request('ordamt') - ((request('ordamt') * $coupon->description) / 100);
                    }
                    return response(['message' => 'couponcode accepted', 'newamt' => $newamt, 'coupon' => $coupon]);
                } else {
                    return response(['message' => 'Date of the coupon code expired'], 401);
                }
            } else {
                return response(['message' => 'Order Amont is less than that of expected'], 401);
            }
        } else {
            return response(['message' => 'Invalid Coupon Code'], 401);
        }
    }

    function dateIsInBetween($startDate, $endDate, $cmpDate)
    {
        return (date($cmpDate) > date($startDate)) && (date($cmpDate) < date($endDate));
    }

    public function settings()
    {
        $data['setting'] = Setting::find(1);
        $data['setting']->image = env('APP_IMAGE');
        return response($data);
    }

    public function newreserve()
    {
        $data = request()->all();
        $data['upsells'] = serialize($data['upsells']);
        $data['orderid'] = time();
        Booking::create($data);
        return response(['message' => 'Booking made successfully']);
    }

    public function getbookings_active($id)
    {
        $data['booking'] = Booking::where(['cus_code' => $id, 'bookingstatus' => 0])->orderBy('id', 'desc')->get();

        foreach ($data['booking'] as $value) {
            // $date = date('Y-m-d', strtotime($value->res_from_date));

            $tempDate = explode('/', $value->res_from_date);
            $date = $tempDate[2] . '-' . $tempDate[1] . '-' . $tempDate[0];
            //dd($date);

            $value->res_from_date = date('d F,y', strtotime($date));

            $tempDate = explode('/', $value->res_to_date);
            $date = $tempDate[2] . '-' . $tempDate[1] . '-' . $tempDate[0];

            $value->res_to_date = date('d F,y', strtotime($date));
            $value->res_fm_time = date('H:i a', strtotime($value->res_fm_time));
            $value->res_to_time = date('H:i a', strtotime($value->res_to_time));
            $value->upsells = unserialize($value->upsells);
        }
        return response($data);
    }

    public function getbookings_cancelled($id)
    {
        $data['booking'] = Booking::where(['cus_code' => $id, 'bookingstatus' => 1])->get();

        foreach ($data['booking'] as $value) {
            $tempDate = explode('/', $value->res_from_date);
            $date = $tempDate[2] . '-' . $tempDate[1] . '-' . $tempDate[0];
            //dd($date);

            $value->res_from_date = date('d F,y', strtotime($date));

            $tempDate = explode('/', $value->res_to_date);
            $date = $tempDate[2] . '-' . $tempDate[1] . '-' . $tempDate[0];

            $value->res_to_date = date('d F,y', strtotime($date));
            $value->res_fm_time = date('H:i a', strtotime($value->res_fm_time));
            $value->res_to_time = date('H:i a', strtotime($value->res_to_time));
            $value->upsells = unserialize($value->upsells);
        }
        return response($data);
    }

    public function getbooking($id)
    {
        $value = Booking::find($id);
        // $value->res_from_date = date('d F,y', strtotime($value->res_from_date));
        // $value->res_to_date = date('d F,y', strtotime($value->res_to_date));
        // $value->res_fm_time = date('H:i a', strtotime($value->res_fm_time));
        // $value->res_to_time = date('H:i a', strtotime($value->res_to_time));
        $value->upsells = unserialize($value->upsells);
        $value->created_at = $value->created_at->toDateTimeString();
        return response($value);
    }

    public function postreview($id)
    {
        $data = request()->all();
        Booking::find($id)->update(['review' => 1]);
        Review::create($data);
        return response(['message' => 'Review recieved']);
    }

    public function cancelbooking($id)
    {
        Booking::find($id)->update(['bookingstatus' => 1]);
        return response(['message' => 'Booking Cancelled']);
    }

    public function validatesearch()
    {
        $data = request()->all();
        date_default_timezone_set($this->setting->timezone);
        $date = Carbon::parse($data['pickupp']);
        $time = Carbon::parse($data['pickuptime']);

        $dateTime = $date->format('d-m-Y') . ' ' . $time->format('H:i:s');

        $pickupDate = Carbon::createFromFormat('d-m-Y H:i:s', $dateTime);
        $diff = $pickupDate->diffInHours(now());

        if ($this->setting->minadvance > $diff) {
            return response(['message' => 'No Cars Available'], 403);
        }

        // return response($data, 401);

        $data['pickupp'] = date('d/m/Y', strtotime($data['pickupp']));
        $data['returndate'] = date('d/m/Y', strtotime($data['returndate']));
        $data['pickuptime'] = date('h:i a', strtotime($data['pickuptime']));
        $data['dropHour'] = date('h:i a', strtotime($data['dropHour']));

        // return response($data, 401);

        if ($data['pickupp'] === $data['returndate']) {
            return response(['message' => 'No Cars Available'], 401);
        }

        // if ($data['pickupp'] < $data['returndate']) {
        //     return response(['message' => 'Pickup Date must be greater than that of Return date'], 401);
        // }

        return response($data);
    }

    public function settings_e()
    {
        return response($this->setting);
    }

    public function createstripe()
    {
        $data = request()->all();
    }

    public function checkout()
    {

        \Stripe\Stripe::setApiKey(env('STRIPE_SECRET_KEY'));
        header('Content-Type: application/json');

        $checkout_session = \Stripe\Checkout\Session::create([
            'line_items' => [[
                'price_data' => [
                    'unit_amount' => (int)(request('amt') * 100),
                    'currency' => 'gbp',
                    'product_data' => [
                        'name' => 'test'
                    ]
                ],
                'quantity' => 1,
            ]],
            'payment_method_types' => [
                'card',
            ],
            'mode' => 'payment',
            'success_url' => url('/thankyou'),
            'cancel_url' => url('/error'),
        ]);
        header("HTTP/1.1 303 See Other");
        return Redirect::to($checkout_session->url);
        // die($checkout_session->url);
        // header("HTTP/1.1 303 See Other");
        // header("Location: " . $checkout_session->url);
        // return view('checkout');
    }

    public function postcheckout()
    {
        // Stripe::setApiKey(env('STRIPE_SECRET_KEY'));

        $stripe = new \Stripe\StripeClient(
            env('STRIPE_SECRET_KEY')
        );


        // $stripe->products->create(['name' => 'T-shirt',]);

        dd($stripe);

        header('Content-Type: application/json');
    }

    public function getvehicletype()
    {
        $data = CarType::where(['status' => 1])->get();
        return response($data);
    }

    public function deluser($id)
    {
        User::find($id)->delete();
        return response(['message' => 'data deleted']);
    }
}
