<?php

namespace App\Http\Controllers\admin\upsell;

use App\Http\Controllers\Controller;
use App\Models\Upsell;
use Illuminate\Http\Request;

class UpsellController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $coupon = Upsell::all();
        return view('admin.upsell.index')->with(['coupon' => $coupon]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.upsell.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->all();
        if ($request->hasFile('image')) {
            $data['image'] = $request->image->storeAs('/public/images', time().".".$request->image->extension());
        }
        Upsell::create($data);
        return redirect('/admin/upsell')->with('success','Uploaded Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $coupon = Upsell::find($id);
        return view('admin.upsell.edit')->with(['coupon' => $coupon]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->all();
        if ($request->hasFile('image')) {
            $data['image'] = $request->image->storeAs('/public/images', time().".".$request->image->extension());
        }
        Upsell::find($id)->update($data);
        return redirect('/admin/upsell')->with('success','Data Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Upsell::find($id)->delete();
        return redirect('/admin/upsell')->with('success','Data Deleted Successfully');
    }
}
