<?php

namespace App\Http\Controllers\admin\review;

use App\Models\Car;
use App\Models\User;
use App\Models\Review;
use Illuminate\Http\Request;
use App\Http\Livewire\Rating;
use App\Http\Controllers\Controller;

class ReviewController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $coupon = Review::join('users', 'users.id', '=', 'reviews.byuser')
            ->join('cars', 'cars.id', '=', 'reviews.forcar')
            ->select('reviews.*', 'users.email', 'cars.name')
            ->get();
        return view('admin.review.index')->with(['review' => $coupon]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $data['user'] = User::where(['status' => 1])->get();
        $data['car'] = Car::where(['status' => 1])->get();
        return view('admin.review.create')->with($data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->all();
        Review::create($data);
        return redirect('/admin/review')->with('success', 'Uploaded Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data['review'] = Review::find($id);
        $data['user'] = User::where(['status' => 1])->get();
        $data['car'] = Car::where(['status' => 1])->get();
        return view('admin.review.edit')->with($data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->all();
        // if ($request->hasFile('image')) {
        //     $data['image'] = $request->image->storeAs('/public/images', time() . "." . $request->image->extension());
        // }
        Review::find($id)->update($data);
        return redirect('/admin/review')->with('success', 'Data Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Review::find($id)->delete();
        return redirect('/admin/review')->with('success', 'Data Deleted Successfully');
    }
}
