<?php

namespace App\Http\Controllers\admin\pickupdrop;

use Illuminate\Http\Request;
use App\Models\PickupDropLocation;
use App\Http\Controllers\Controller;

class PickupDropLocationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $location = PickupDropLocation::all();
        return view('admin.pickupdrop.index')->with(['location' => $location]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.pickupdrop.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->all();

        // if ($request->hasFile('image')) {
        //     $data['image'] = $request->image->storeAs('/public/images', time().".".$request->image->extension());
        // }
        PickupDropLocation::create($data);
        return redirect('/admin/pickupdrop')->with('success','Uploaded Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $location = PickupDropLocation::find($id);
        return view('admin.pickupdrop.edit')->with(['location' => $location]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->all();
        // if ($request->hasFile('image')) {
        //     $data['image'] = $request->image->storeAs('/public/images', time().".".$request->image->extension());
        // }
        PickupDropLocation::find($id)->update($data);
        return redirect('/admin/pickupdrop')->with('success','Data Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        PickupDropLocation::find($id)->delete();
        return redirect('/admin/pickupdrop')->with('success','Data Deleted Successfully');
    }
}
