<?php

namespace App\Http\Controllers\admin\cars;

use App\Models\Car;
use App\Models\CarType;
use App\Models\CarModel;
use Illuminate\Http\Request;
use App\Models\PickupDropLocation;
use App\Http\Controllers\Controller;
use App\Models\Setting;

class CarController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $advertisement = Car::join('car_models', 'cars.carmodel_id', '=', 'car_models.id')
            ->join('car_types','cars.cartype_id', '=', 'car_types.id')
            ->select('cars.*', 'car_models.name as modelname','car_types.name as categoryname',)
            ->get();

        $currency = Setting::find(1)['curr'];
        return view('admin.car.index')->with(['advertisement' => $advertisement, 'currency' => $currency]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $carmodel = CarModel::where(['status' => '1'])->get();
        $cartype = CarType::where(['status' => '1'])->get();
        $locations = PickupDropLocation::where(['status' => '1'])->get();
        return view('admin.car.create')->with(['carmodel' => $carmodel, 'cartype' => $cartype, 'drop' => $locations]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->all();

        if ($request->hasFile('image')) {
            foreach ($request->file('image') as $file) {
                $name = $file->storeAs('/public/images', rand() . '.' . $file->extension());
                $image[] = $name;
            }
            $data['image'] = serialize($image);
        }

        $data['station_ids'] = implode(',', $data['station_ids']);
        // dd($data);
        Car::create($data);
        return redirect('/admin/cars')->with('success', 'Uploaded Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $carmodel = CarModel::where(['status' => '1'])->get();
        $cartype = CarType::where(['status' => '1'])->get();
        $locations = PickupDropLocation::where(['status' => '1'])->get();
        $advertisement = Car::find($id);
        $advertisement['image'] = unserialize($advertisement['image']);
        return view('admin.car.edit')->with(['advertisement' => $advertisement, 'carmodel' => $carmodel, 'cartype' => $cartype, 'drop' => $locations]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->all();
        $car = Car::find($id);
        if (isset($data['station_ids'])) {
            $care = unserialize($car->image);
            if ($request->hasFile('image')) {
                foreach ($request->file('image') as $file) {
                    $name = $file->storeAs('/public/images', rand() . '.' . $file->extension());
                    $image[] = $name;
                }
                $data['image'] = serialize(array_merge($image, $care));
            }

            $data['station_ids'] = implode(',', $data['station_ids']);
        }
        
        
        Car::find($id)->update($data);
        return redirect('/admin/cars')->with('success', 'Data Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

        Car::find($id)->delete();
        return redirect('/admin/cars')->with('success', 'Data Deleted Successfully');
    }

    public function delimage()
    {
        $car = Car::find(request('carid'));
        $care = unserialize($car->image);

        $key = array_search(request('imageindex'), $care);
        unset($care[$key]);
        $data['image'] = serialize(array_values($care));

        Car::find(request('carid'))->update($data);
        return redirect()->back()->with('success', 'Data Deleted Successfully');
    }
}
