<?php

namespace App\Http\Controllers\admin\booking;

use App\Http\Controllers\Controller;
use App\Models\Booking;
use App\Models\Car;
use App\Models\CarType;
use App\Models\User;
use Illuminate\Http\Request;

class BookingController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // return date_default_timezone_get();
        // return config('app.timezone');
        // return now()->format('h:i:s A');
        $data['booking'] = Booking::orderBy('id', 'desc')->get();
        foreach ($data['booking'] as $value) {
            $value->user = User::find($value->cus_code);
            $value->cartype = Car::find($value->carid);
            $value->cartype = CarType::find($value->cartype->cartype_id)->name;
            // $value->res_from_date = date('d F,y', strtotime($value->res_from_date));
            // $value->res_to_date = date('d F,y', strtotime($value->res_to_date));
            // $value->res_fm_time = date('H:i a', strtotime($value->res_fm_time));
            // $value->res_to_time = date('H:i a', strtotime($value->res_to_time));
            $value->upsells = unserialize($value->upsells);
        }

        // $data['booking'] = array_reverse($data['booking']);

        // dd($data['booking']);
        return view('admin.booking.index')->with($data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.booking.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $value = Booking::find($id);
        // $value->res_from_date = date('d F,y', strtotime($value->res_from_date));
        // $value->res_to_date = date('d F,y', strtotime($value->res_to_date));
        // $value->res_fm_time = date('H:i a', strtotime($value->res_fm_time));
        // $value->res_to_time = date('H:i a', strtotime($value->res_to_time));
        $value->upsells = unserialize($value->upsells);

        $user = User::find($value->cus_code);
        // dd($value);
        return view('admin.booking.edit')->with(['booking' => $value, 'user' => $user]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Booking::find($id)->delete();
        return redirect()->back()->with('success', 'Data Deleted Successfully');
    }
}
