<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBookingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bookings', function (Blueprint $table) {
            $table->id();
            $table->string('cus_code')->nullable();
            $table->string('station_code')->nullable();
            $table->string('car_model')->nullable();
            $table->string('carname')->nullable();
            $table->string('carid')->nullable();
            $table->string('res_from_date')->nullable();
            $table->string('res_to_date')->nullable();
            $table->string('res_fm_time')->nullable();
            $table->string('res_to_time')->nullable();
            $table->string('dlv_tel')->nullable();
            $table->string('dlv_add')->nullable();
            $table->string('days')->nullable();
            $table->string('daily_price')->nullable();
            $table->string('coupon')->nullable();
            $table->string('couponcode')->nullable();
            $table->string('couponoffer_type')->nullable();
            $table->string('couponamt')->nullable();
            $table->string('totaltaxamount')->nullable();
            $table->string('total')->nullable();
            $table->string('upsellsamt')->nullable();
            $table->text('upsells')->nullable();
            $table->string('finaltotal')->nullable();
            $table->string('status')->default(0);
            $table->string('review')->default(0);
            $table->string('device')->default('ios');
            $table->string('payment')->default('cash');
            $table->string('bookingstatus')->default(0);
            $table->string('paymentstatus')->default('Not Paid');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bookings');
    }
}
