<?php

namespace App\Http\Controllers\appapi;

use App\Models\Pages;
use App\Models\User;
use App\Mail\IdnoMail;
use App\Models\Service;
use App\Mail\ContactMail;
use App\Mail\RegisterMail;
use App\Mail\ForgotPassword;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\api\ApiController;
use App\Http\Controllers\api\ApicallController;
use App\Http\Controllers\price\PriceingController;
use Illuminate\Support\Facades\Hash;

class AppapiController extends Controller
{
    public function getsearchdata()
    {
        $data['ListStation'] = (new ApiController)->show('PCRLookup/ListStation');

        $data['ListStation'] = $data['ListStation']['Result']['stationList'];
        unset($data['ListStation'][0]);
        unset($data['ListStation'][3]);
        unset($data['ListStation'][4]);
        unset($data['ListStation'][5]);
        unset($data['ListStation'][8]);
        unset($data['ListStation'][16]);
        unset($data['ListStation'][11]);
        // $data['ListVehicleMakeModel'] = (new ApiController)->show('PCRLookup/ListVehicleMakeModel');
        // $data['ListVehicleMakeModel'] = $data['ListVehicleMakeModel']['Result']['vehicleMakeModelList'];


        $pickuptime = $this->converttime(request('pickuptime'));
        $droptime = $this->converttime(request('dropHour'));
        $pickupp = $this->convertdate(request('pickupp'));
        $data['pickupdatetime'] = (new PriceingController)->datetimetotzformat($pickupp, $pickuptime);
        $data['dropdatetime'] = (new PriceingController)->datetimetotzformat($pickupp, $pickuptime);
        $data['pickuplocation'] = request('pickuplocation');

        $data['vehicleViewModelList'] = (new ApiController)->show('PCRVehicle/ListVehicle_Available_Date?stationCode=' . $data['pickuplocation'] . '&fromDate=' . $data['pickupdatetime'] . '&toDate=' . $data['dropdatetime']);
        $data['vehicleList'] = $data['vehicleViewModelList']['Result']['vehicleViewModelList'];

        $data['ListVehicleMakeModel'] = $this->getmakemodel($data['vehicleList']);
        // dd($data['ListVehicleMakeModel']);

        $days = $this->getnumberofdays();
        if ($days == 0) {
            $days = 1;
        }

        $data['days'] = $days;

        $data['namelocation'] = (new ApiController)->show('PCRLookup/ListStation');
        // dd($data['namelocation']['Result']['stationList']);
        $data['pickupnamelocation'] = $this->getstationname($data['namelocation']['Result']['stationList'], request('pickuplocation'));
        $data['returnnamelocation'] = $this->getstationname($data['namelocation']['Result']['stationList'], request('returnlocation'));
        if (request('luggage')) {
            // dd(request('luggage'));
            $data['vehicleList']  = $this->filterluggage(request('luggage'), $data['vehicleList']);
        }

        // if (request('door')) {
        //     $data['vehicleList']  = $this->filterdoor(request('door'),$data['vehicleList']);
        // }

        if (request('sort')) {
            usort($data['vehicleList'], function ($a, $b) {
                return $a['daily_price'] <=> $b['daily_price'];
            });

            if (request('sort') == 'hightolow') {
                $data['vehicleList'] = array_reverse($data['vehicleList']);
            }
        }

        $data['vehicleList'] = $this->pushimage($data['vehicleList']);
        return response($data);
    }

    public function getmakemodel($var)
    {

        $unique = array();

        foreach ($var as $value) {
            $unique[$value['car_make_code']] = $value;
        }

        return $data = array_values($unique);
        // dd($data);
    }

    public function pushimage($data)
    {
        for ($i = 0; $i < count($data); $i++) {

            switch ($data[$i]['car_model']) {
                case 'Mazda3':
                    $data[$i]['car_image'] = env('APP_URL') . 'carimage/800-600/Mazda3.png';
                    break;
                case "Mazda CX9":
                    $data[$i]['car_image'] = env('APP_URL') . 'carimage/1360-903/mazda_CX-9-2019-2020.jpg';
                    break;
                case "Kia Rio":
                    $data[$i]['car_image'] = env('APP_URL') . 'carimage/1360-903/kia-rio-2020.jpg';
                    break;
                case 'Mazda6 S':
                    $data[$i]['car_image'] = env('APP_URL') . 'carimage/1360-903/MAZDA-CX5-2018-2019-2020.jpg';
                    break;
                case "Mazda CX3":
                    $data[$i]['car_image'] = env('APP_URL') . 'carimage/1360-903/Mazda-CX-3-2020-2019-2018.jpg';
                    break;
                case "Mazda6":
                    $data[$i]['car_image'] = env('APP_URL') . 'carimage/800-600/mazda-6-2019-2020.jpg';
                    break;
                default:
                    $data[$i]['car_image'] = env('APP_URL') . 'carimage/1360-903/Elantra-2019.jpg';
            }
        }
        return $data;
    }

    public function getstationname($array, $id)
    {
        foreach ($array as $value) {
            if ($value['s_code'] == $id) {
                return $value['s_name'];
            }
        }
    }

    public function filterdoor($door, $vehicleViewModelList)
    {
        $array = [];
        for ($i = 0; $i < count($vehicleViewModelList); $i++) {
            if (intval($vehicleViewModelList[$i]['doors']) == intval($door)) {
                array_push($array, $vehicleViewModelList[$i]);
            }
        }
        return $array;
    }

    public function filterluggage($luggagenumber, $vehicleViewModelList)
    {
        // dd($vehicleViewModelList);
        $array = [];
        for ($i = 0; $i < count($vehicleViewModelList); $i++) {
            if (intval($vehicleViewModelList[$i]['car_make_code']) == intval($luggagenumber)) {
                array_push($array, $vehicleViewModelList[$i]);
            }
        }
        return $array;
    }

    public function getnumberofdays()
    {
        $pickupdate = strtotime(request('pickupp') . ' ' . request('pickuptime')); // or your date as well
        $return_date = strtotime(request('returndate') . ' ' . request('dropHour'));
        $datediff = $pickupdate - $return_date;

        return ceil(abs(intval(round($datediff / (60 * 60)))) / 24);
    }

    public function converttime($pickuptime)
    {
        return date_format(date_create($pickuptime), 'H:i:s');
    }

    public function convertdate($pickuptime)
    {
        return date_format(date_create($pickuptime), 'Y/m/d');
    }

    public function createuser()
    {
        $data = request()->all();

        // return response($data);

        // dd($data);
        // if (!$data['per_city']) {
        //     $data['per_city'] == '0';
        // }

        // if (!$data['birth_city']) {
        //     $data['birth_city'] == '0';
        // }
        $val = (new ApicallController)->authenticatepostdata('PCRCustomer/NewCustomer', $data)->content();
        // dd($val);
        $val = json_decode($val);

        if ($val->Status == 201) {
            // $data = [
            //     'username' => request('e_mail'),
            //     'password' => request('online_password')
            // ];

            $data = Pages::find(5);
            // if (session('language') == 'Arabic') {
            //     $data->description = str_replace("%%USERNAME%%",request('e_mail'),$data['description_a']);
            //     Mail::to(env('ADMIN_MAIL_ADDRESS'))->send(new RegisterMail($data));
            //     Mail::to(request('e_mail'))->send(new RegisterMail($data));
            //     session()->flash('succmessage', 'تم التسجيل بنجاح ، قم بتسجيل الدخول الآن');
            // } else {
            $data->description = str_replace("%%USERNAME%%", request('e_mail'), $data['description']);
            Mail::to(env('ADMIN_MAIL_ADDRESS'))->send(new RegisterMail($data));
            Mail::to(request('e_mail'))->send(new RegisterMail($data));
            // session()->flash('succmessage', 'Registered Successfully,Login Now');
            // }
            return response(['message' => 'Registered Successfully,Login Now']);
            // return redirect('/');
        } else {
            return response(['message' => 'try again'], 401);
            // if (session('language') == 'Arabic') {
            //     session()->flash('errormessage', 'رقم الهوية موجود بالفعل');
            // return redirect('/');
            // } else {
            //     session()->flash('errormessage', 'Id Number Already exists');
            // return redirect('/');
            // }
        }
    }

    public function updateuser()
    {
        $data = request()->all();
        $token = $data['Token'];
        if (!isset($data['birth_city'])) {
            $data['birth_city'] = 0;
        }

        if (!isset($data['per_city'])) {
            $data['per_city'] = 0;
        }

        $res = (new ApicallController)->authenticatepostdata('PCRCustomer/EditCustomer?customerCode=' . $data['cus_code'], $data, $token);

        // $res = json_decode($res->content());
        return $res;
    }

    public function getservice()
    {
        $data['service'] = Service::where(['status' => 1])->get();
        for ($i = 0; $i < count($data['service']); $i++) {
            $data['service'][$i]['image'] = env('APP_URL') . ltrim(Storage::url($data['service'][$i]['image']), Storage::url($data['service'][$i]['image'])[0]);
        }
        return response($data['service']);
    }

    public function bookings()
    {
        $cus_code = request('cus_code');
        $Token = request('Token');
        $data['currentbooking'] = (new ApicallController)->getauthenticateddata('PCRReservation/ListReservation?customerCode=' . $cus_code . '&statusCode=V', $Token);
        $data['cancelledbooking'] = (new ApicallController)->getauthenticateddata('PCRReservation/ListReservation?customerCode=' . $cus_code . '&statusCode=C', $Token);
        $data['currentbooking'] = array_reverse($data['currentbooking']['Result']['reservationViewModelLists']);
        $data['currentbooking']['Result']['reservationViewModelLists'] = $this->getpaidbooking($data['currentbooking']);
        return response($data);
    }

    public function getpaidbooking($var)
    {
        $array = [];
        foreach ($var as $value) {
            if ($value['prepaid'] == "1") {
                array_push($array, $value);
            }
        }
        return $array;
    }

    public function newreserve()
    {
        $data = request('message');

        $val = (new ApicallController)->authenticatepostdata('PCRReservation/NewReservation', $data, request('Token'));
        return $val->content();
    }

    public function pay($id, $amt, $token)
    {
        $reservedata = (new ApicallController)->getauthenticateddata('PCRReservation/ViewReservation?reservationCode=' . $id, $token);
        $customer = (new ApicallController)->getauthenticateddata('PCRCustomer/ViewCustomer?customerCode=' . $reservedata['Result']['reservationViewModel']['cus_code'], $token);
        $data['reservesession']['amountpais'] = $amt;
        $data['reservesession']['dlv_add'] = $customer['Result']['customerViewModel']['e_mail'];
        $data['reservesession']['reservationid'] = $id;
        // $data['reservesession']['url'] = url()->previous();
        return view('frontend.payment')->with($data);
    }

    public function pages()
    {
        $data['page'] = Pages::all();
        for ($i = 0; $i < count($data['page']); $i++) {
            $data['page'][$i]['image'] = env('APP_URL') . '/' . ltrim(Storage::url($data['page'][$i]['image']), Storage::url($data['page'][$i]['image'])[0]);
        }
        return response($data);
    }

    public function postcontact()
    {
        $val = request()->all();
        $data = Pages::find(12);

        if (session('language') == 'Arabic') {
            $data->description = str_replace(["%%CUSTOMER_NAME%%", "%%CUSTOMER_PHONE%%", "%%CUSTOMER_EMAIL%%", "%%MESSAGE%%"], [$val['name'], $val['phone'], $val['email'], $val['message']], $data->description_a);
        } else {
            $data->description = str_replace(["%%CUSTOMER_NAME%%", "%%CUSTOMER_PHONE%%", "%%CUSTOMER_EMAIL%%", "%%MESSAGE%%"], [$val['name'], $val['phone'], $val['email'], $val['message']], $data->description);
        }
        Mail::to(env('ADMIN_MAIL_ADDRESS'))->send(new ContactMail($data));
        Mail::to($val['email'])->send(new ContactMail($data));
        return response(['message' => 'mail send']);
    }

    public function forgotpass()
    {
        $var = json_decode((new ApicallController())->postdata('PCRCustomer/CheckEmail?email=' . request('useremail'))->content());

        if ($var->Status == 202) {
            // $res = json_decode((new ApicallController())->postdata('PCRCustomer/CustomerByIdNo',['cus_code'=>$var->Result->cus_code,'password' => '12345678'])->content());
            $var->Result->cus_code = $this->base64url_encode($var->Result->cus_code);
            // $var->Result->cus_code = $this->base64url_decode($var->Result->cus_code);
            // dd($var->Result->cus_code);
            $data = Pages::find(7);
            if (session('language') == 'Arabic') {
                $data->description = str_replace(["%%CUSTOMER_NAME%%", "%%CUSTOMER_CODE%%"], [$var->Result->e_mail, $var->Result->cus_code], $data['description_a']);
                Mail::to($var->Result->e_mail)->send(new ForgotPassword($data));
                // session()->flash('succmessage', 'تم إرسال البريد بنجاح ، قم بتحديث كلمة المرور من الرابط المحدد');
            } else {
                $data->description = str_replace(["%%CUSTOMER_NAME%%", "%%CUSTOMER_CODE%%"], [$var->Result->e_mail, $var->Result->cus_code], $data['description']);
                Mail::to($var->Result->e_mail)->send(new ForgotPassword($data));
                // session()->flash('succmessage', 'Mail Send Successfully, Update Password From The given Link');
            }


            return response(['message' => 'mail send']);
        } else {
            return response(['message' => 'Not found email'], 404);
        }
    }

    public function forgotpassword(){
        $useremail = request('useremail');
        // $useremail = 'sailapritam@gmail.com';
        // dd(request('useremail'));
        $user = User::where(['email' => $useremail])->first();
        if ($user) {
            $newpass = time();
            User::where(['email' => $useremail])->update(['password' => Hash::make($newpass)]);
            $data = $user;
            $data->code = $newpass;
            Mail::to($data->email)->send(new ForgotPassword($data));
            return response(['message' => 'mail send']);
        } else {
            return response(['message' => 'Not found email'], 404);
        }
        
        // return response($user);
        // $var->Result->cus_code = $this->base64url_encode($var->Result->cus_code);
        
    }

    public function base64url_encode($data)
    {
        return rtrim(strtr(base64_encode($data), '+/', '-_'), '=');
    }

    public function idchange()
    {
        $idno = request('idno');

        $res = json_decode((new ApicallController)->postdata('PCRCustomer/CustomerByIdNo?idno=' . $idno)->content());
        // dd($res->Result);
        if ($res->Status == 201) {
            $data = Pages::find(8);
            if (session('language') == 'Arabic') {
                $data->description = str_replace(["%%CUSTOMER_EMAIL%%", "%%CUSTOMER_NAME%%", "%%CUSTOMER_PHONE%%", "%%CUSTOMER_ID%%"], [$res->Result->e_mail, $res->Result->cus_name, $res->Result->per_mobile, $res->Result->id_no], $data['description_a']);
            } else {
                $data->description = str_replace(["%%CUSTOMER_EMAIL%%", "%%CUSTOMER_NAME%%", "%%CUSTOMER_PHONE%%", "%%CUSTOMER_ID%%"], [$res->Result->e_mail, $res->Result->cus_name, $res->Result->per_mobile, $res->Result->id_no], $data['description']);
            }
            Mail::to($res->Result->e_mail)->send(new IdnoMail($data));
            return response(['message' => 'mail send']);
        } else {
            return response(['message' => 'Not found email'], 404);
        }
    }
}
