<?php

namespace App\Http\Controllers\admin\carstype;

use App\Models\CarType;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class CarsTypeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $location = CarType::all();
        return view('admin.carstype.index')->with(['location' => $location]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.carstype.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->all();
        // if ($request->hasFile('image')) {
        //     $data['image'] = $request->image->storeAs('/public/images', time().".".$request->image->extension());
        // }
        CarType::create($data);
        return redirect('/admin/carstype')->with('success','Uploaded Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $location = CarType::find($id);
        return view('admin.carstype.edit')->with(['location' => $location]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->all();
        // if ($request->hasFile('image')) {
        //     $data['image'] = $request->image->storeAs('/public/images', time().".".$request->image->extension());
        // }
        CarType::find($id)->update($data);
        return redirect('/admin/carstype')->with('success','Data Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        CarType::find($id)->delete();
        return redirect('/admin/carstype')->with('success','Data Deleted Successfully');
    }
}
