<?php

namespace App\Http\Controllers\admin\carsmodel;

use App\Models\CarModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class CarsModelController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $location = CarModel::all();
        return view('admin.carsmodel.index')->with(['location' => $location]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.carsmodel.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->all();
        $logoPath = "/public/images/logos";
        if ($request->hasFile('logo')) {
            $data['logo'] = $request->image->storeAs($logoPath, time().".".$request->image->extension());
        }
        CarModel::create($data);
        return redirect('/admin/carsmodel')->with('success','Model created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $location = CarModel::find($id);
        return view('admin.carsmodel.edit')->with(['location' => $location]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->all();
        $logoPath = "/public/images/logos";
        if ($request->hasFile('logo')) {
            $data['logo'] = $request->image->storeAs($logoPath, time().".".$request->image->extension());
        }
        CarModel::find($id)->update($data);
        return redirect('/admin/carsmodel')->with('success','Data Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        CarModel::find($id)->delete();
        return redirect('/admin/carsmodel')->with('success','Data Deleted Successfully');
    }
}