<?php

namespace App\Http\Controllers;
use App\Models\Pages;

use App\Mail\OrderMail;
use App\Mail\CancelOrder;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Http\Controllers\api\ApiController;
use App\Http\Controllers\api\ApicallController;

class AjaxConrtoller extends Controller
{
    public function getstate()
    {
        $data = (new ApiController)->show('PCRLookup/ListCityByCountry?countryCode='.request('countrycode'));
        return response($data['Result']['cityList']);
    }

    public function NewReservation()
    {
        return response(request('message'));
        session_start();
        $data = request('message');

        $_SESSION['reservesession'] = $data['amountpais'];
        unset($data['amountpais']);
        
        $val = (new ApicallController)->authenticatepostdata('PCRReservation/NewReservation',$data,request('Token'));
        echo json_encode(json_decode($val->content()));
    }

    public function finalreservation()
    {
        $var = request()->all();
        if ($var['response_message'] == "Success") {
        $price = $var['amount']/100;
            return redirect('/ultimatereservation/'.$var['order_description'].'/'.$price);
        } else {
            return redirect('/cancel');
        }
    }

    public function ultimatereservation($id,$price)
    {
        $reservedata = (new ApicallController)->getauthenticateddata('PCRReservation/ViewReservation?reservationCode='.$id);
        $reservedata['Result']['reservationViewModel']['prepaid'] = 1;
        $data = $reservedata['Result']['reservationViewModel'];
        $customer = (new ApicallController)->getauthenticateddata('PCRCustomer/ViewCustomer?customerCode='.$data['cus_code']);
        $data['customer'] = $customer['Result']['customerViewModel'];
        $data['datetime'] = date("Y-m-d h:i:sa");
        $data['res_from_date'] = explode('T',$data['res_from_date'])[0];
        $data['res_to_date'] = explode('T',$data['res_to_date'])[0];
        $data['price'] = $price;
        $var = Pages::find(6);
        $newarray = [];
        if (session('language') == 'Arabic') {
            $newarray['description'] = str_replace(["%%CUSTOMER_NAME%%","%%RESERVATION_NUMBER%%","%%CAR_MODEL%%","%%RESERVATION_FROM%%","%%RESERVATION_TO%%","%%PRICE%%"],[$data['customer']['cus_name'],$data['car_model'],$data['res_from_date'],$data['res_to_date'],$data['price']],$var['description_a']);
        } else {
            $newarray['description'] = str_replace(["%%CUSTOMER_NAME%%","%%CAR_MODEL%%","%%RESERVATION_NUMBER%%","%%RESERVATION_FROM%%","%%RESERVATION_TO%%","%%PRICE%%"],[$data['customer']['cus_name'],$data['car_model'],$id,$data['res_from_date'],$data['res_to_date'],$data['price']],$var['description']);
        }
        Mail::to(env('ADMIN_MAIL_ADDRESS'))->bcc('deltarohit@gmail.com')->send(new OrderMail($newarray));
        $res = (new ApicallController)->authenticatepostdata('PCRReservation/EditReservation?reservationCode='.$id,$reservedata['Result']['reservationViewModel']);
        // dd(json_decode($res->content())->Status);
        if (json_decode($res->content())->Status == 201) {
            return redirect('thankyou');
        }
    }

    public function cancelbooking($id,$token)
    {
        $val = (new ApicallController)->getauthenticateddatapost('PCRReservation/CancelReservation?reservationCode='.$id,$token);
        $reservedata = (new ApicallController)->getauthenticateddata('PCRReservation/ViewReservation?reservationCode='.$id,$token);
        $reservedata['Result']['reservationViewModel']['prepaid'] = 1;
        $data = $reservedata['Result']['reservationViewModel'];
        $customer = (new ApicallController)->getauthenticateddata('PCRCustomer/ViewCustomer?customerCode='.$data['cus_code'],$token);
        $data['customer'] = $customer['Result']['customerViewModel'];
        $data['datetime'] = date("Y-m-d h:i:sa");
        $data['res_from_date'] = explode('T',$data['res_from_date'])[0];
        $data['res_to_date'] = explode('T',$data['res_to_date'])[0];

        $var = Pages::find(11);
        $newarray = [];
        if (session('language') == 'Arabic') {
            $newarray['description'] = str_replace(["%%CUSTOMER_NAME%%","%%RESERVATIONNO%%"],[$data['customer']['cus_name'],$id],$var['description_a']);
        } else {
            $newarray['description'] = str_replace(["%%CUSTOMER_NAME%%","%%RESERVATIONNO%%"],[$data['customer']['cus_name'],$id],$var['description']);
        }
        Mail::to($data['customer']['e_mail'])->send(new CancelOrder($newarray));
        Mail::to(env('ADMIN_MAIL_ADDRESS'))->bcc('deltarohit@gmail.com')->send(new CancelOrder($newarray));
        echo json_encode('cancelled');
    }

    public function stationlist($id)
    {
        $stnlist = (new ApiController)->show('PCRLookup/ListStation');
        $stnlist = $stnlist['Result']['stationList'];
        // dd($stnlist['Result']['stationList']);
        for ($i=0; $i < count($stnlist); $i++) { 
            if ($stnlist[$i]['s_code'] == $id) {
                $stationname = $stnlist[$i]['s_name'];
            }
        }
        return $stationname;
    }

    public function setlanguage($val)
    {
        if ($val == 'A') {
            session()->put('language','Arabic');
        } else {
            session()->forget('language');
        }
        return session()->get('language');
    }
}
